<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CategoryFinance extends Model 
{

    protected $table = 'finance_category';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'icon', 'sub_of', 'created_by', 'updated_by');

    public function cache()
    {
        return $this->hasMany('App\Models\FinanceCash', 'cat_id');
    }

}